#include <iostream>
#include <cstdio>
#include <string.h>
#include <string>
#include <algorithm>
#include <cmath>
#include <queue>
#include <stack>
#include <vector>
#include <map>
#include <set>
#include <cassert>
#include <time.h>
#include <cstdlib>

using namespace std;

#define ll long long
#define ld long double
#define mp make_pair
#define pb push_back
#define fst first
#define snd second
#define y0 asfdasdfasf
#define y1 askfjasjfas

const int maxn = 1500;
const int inf = 1e9;


vector < pair < int, int > > ans[maxn];
int gc = 0;

int used[500][1500];
int currUsed  = 1;

struct maxFlow
{
	vector < pair < int, int > > g[maxn];
	vector < pair < int, int > > gt[maxn];
	int f[maxn];
	int c[maxn];

	int eCnt;
	int n;

	int s, t;

	int lvl[maxn];
	int pr[maxn];
	maxFlow(int _n)
	{
		n = _n;
		eCnt = 0;
	}

	void addEdge(int u, int v, int cap)
	{
		f[eCnt] = f[eCnt + 1] = 0;
		c[eCnt] = cap;
		c[eCnt + 1] = 0;
		g[u].pb(mp(v, eCnt));
		g[v].pb(mp(u, eCnt + 1));

		gt[v].pb(mp(u, eCnt));
		gt[u].pb(mp(v, eCnt + 1));

		eCnt += 2;
	}


	bool bfs(int ub)
	{
		for (int i = 1; i <= n; i++)
		{
			lvl[i] = -1;
		}

		queue < int > q;
		q.push(s);

		lvl[s] = 0;

		while (!q.empty())
		{
			int v = q.front();
			q.pop();

			for (int i = 0; i < g[v].size(); i++)
			{
				int to = g[v][i].fst;
				int ee = g[v][i].snd;

				if (lvl[to] != -1)
					continue;

				if (!(f[ee] < c[ee]))
					continue;

				lvl[to] = lvl[v] + 1;
				q.push(to);
			}
		}

		return lvl[t] <= ub && lvl[t] != -1;
	}

	void reset()
	{
		for (int i = 0; i < eCnt; i++)
			f[i] = 0;
	}

	int dfs(int v, int flow)
	{
		if (!flow || v == t)
			return flow;

		for (; pr[v] < g[v].size(); pr[v]++)
		{
			int to = g[v][pr[v]].fst;
			int ee = g[v][pr[v]].snd;

			if (lvl[v] + 1 != lvl[to])
				continue;

			if (int res = dfs(to, min(flow, c[ee] - f[ee])))
			{
				f[ee] += res;
				f[ee ^ 1] -= res;
				return res;
			}
		}

		return 0;
	}

	bool dfsAns(int v, int day)
	{
		if (v == t)
			return true;
		for (int i = 0; i < g[v].size(); i++)
		{
			int to = g[v][i].fst;
			int ee = g[v][i].snd;

			if (f[ee] <= 0)
				continue;

			if (used[day][ee] == currUsed)
				continue;

		
			ans[day].pb(mp(gc + 1, to));
			used[day][ee] = currUsed;
			f[ee]--;
			return dfsAns(to, day + 1);
		}

		return false;
	}


	int flow(int day, int ub, int left)
	{
		while (bfs(ub))
		{
			for (int i = 1; i <= n; i++)
				pr[i] = 0;

			while (dfs(s, inf))
			{

			}
		

		}

		int cnt = 0;

		while (dfsAns(s, day))
		{
			gc++;
			cnt++;

			if (cnt == left)
				break;
		}
		
		return cnt;
	}


};
int n, m, k;
maxFlow *flow = new maxFlow(55);

int solve(int ub)
{
	for (int i = 0; i < maxn; i++)
	{
		ans[i].clear();
	}

	int left = k;
	gc = 0;
	currUsed++;
	for (int i = 0; left; i++)
	{
		flow->reset();
		int res = flow->flow(i, ub - i, left);
		if (!res)
			break;
		left -= res;
	}

	if (left)
		return 1e9;

	int ansS = 0;
	while (ans[ansS].size() > 0) ansS++;

	return ansS;
}

int main()
{
	
//	freopen("a.in", "r", stdin);
	

	
	cin >> n >> m >> k;

	cin >> flow->s >> flow->t;

	for (int i = 0; i < m; i++)
	{
		int u, v;
		cin >> u >> v;
		flow->addEdge(u, v, 1);
		flow->addEdge(v, u, 1);
	}

	int mm = 1e9, mi;

	for (int ub = 1; ub < 720; ub++)
	{
		int res = solve(ub);
		if (res < mm)
		{
			mm = res;
			mi = ub;
		}
	}


	solve(mi);

	int ansS = 0;
	while (ans[ansS].size() > 0) ansS++;

	printf("%d\n", ansS);

	for (int i = 0; i < ansS; i++)
	{
		printf("%d", ans[i].size());
		for (auto x : ans[i])
			printf(" %d %d", x.fst, x.snd);

		printf("\n");
	}
	

	return 0;
}
